/*
 * Decompiled with CFR 0.152.
 */
package org.vaulttec.velocity.ui;

import com.langtags.ep4velo.Activator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.vaulttec.velocity.ui.IColorConstants;

public class VelocityColorProvider
implements IColorConstants {
    private static final RGB RGB_DEFAULT = new RGB(0, 0, 0);
    private static final RGB RGB_COMMENT = new RGB(63, 127, 95);
    private static final RGB RGB_DOC_COMMENT = new RGB(63, 150, 192);
    private static final RGB RGB_DIRECTIVE = new RGB(127, 0, 85);
    private static final RGB RGB_STRING = new RGB(42, 0, 255);
    private static final RGB RGB_REFERENCE = new RGB(220, 0, 0);
    private static final RGB RGB_STRING_REFERENCE = new RGB(250, 10, 240);
    protected Map<String, Color> fColorTable = new HashMap<String, Color>(10);

    public static void initializeDefaults(IPreferenceStore aStore) {
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"com.langtags.ep4velo.color.default", (RGB)RGB_DEFAULT);
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"com.langtags.ep4velo.color.comment", (RGB)RGB_COMMENT);
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"com.langtags.ep4velo.color.doc_comment", (RGB)RGB_DOC_COMMENT);
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"com.langtags.ep4velo.color.directive", (RGB)RGB_DIRECTIVE);
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"com.langtags.ep4velo.color.string", (RGB)RGB_STRING);
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"com.langtags.ep4velo.color.reference", (RGB)RGB_REFERENCE);
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"com.langtags.ep4velo.color.string_reference", (RGB)RGB_STRING_REFERENCE);
    }

    public Color getColor(String aName) {
        Color color = this.fColorTable.get(aName);
        if (color == null) {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)("com.langtags.ep4velo.color." + aName));
            if (rgb != null) {
                color = new Color((Device)Display.getCurrent(), rgb);
            } else {
                color = Display.getCurrent().getSystemColor(24);
                Activator.logErrorMessage("Undefined color '" + aName + "'");
            }
            this.fColorTable.put(aName, color);
        }
        return color;
    }

    public void dispose() {
        Iterator<Color> colors = this.fColorTable.values().iterator();
        while (colors.hasNext()) {
            colors.next().dispose();
        }
    }
}

