/*
 * Decompiled with CFR 0.152.
 */
package org.vaulttec.velocity.ui;

import com.langtags.ep4velo.Activator;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class VelocityPluginImages {
    private static URL fgIconBaseURL = null;
    private static final ImageRegistry IMAGE_REGISTRY;
    private static final String T_OBJ = "obj16";
    public static final String IMG_OBJ_SYSTEM_DIRECTIVE = "system_directive_obj.gif";
    public static final String IMG_OBJ_USER_DIRECTIVE = "user_directive_obj.gif";
    public static final String IMG_OBJ_MACRO = "macro_obj.gif";
    public static final ImageDescriptor DESC_OBJ_SYSTEM_DIRECTIVE;
    public static final ImageDescriptor DESC_OBJ_USER_DIRECTIVE;
    public static final ImageDescriptor DESC_OBJ_MACRO;

    static {
        Display display = Display.getCurrent();
        String pathSuffix = display != null && display.getIconDepth() > 4 ? "icons/full/" : "icons/basic/";
        try {
            fgIconBaseURL = new URL(Activator.getDefault().getBundle().getEntry("/"), pathSuffix);
        }
        catch (MalformedURLException e) {
            Activator.log(e);
        }
        IMAGE_REGISTRY = Activator.getDefault().getImageRegistry();
        DESC_OBJ_SYSTEM_DIRECTIVE = VelocityPluginImages.createManaged(T_OBJ, IMG_OBJ_SYSTEM_DIRECTIVE);
        DESC_OBJ_USER_DIRECTIVE = VelocityPluginImages.createManaged(T_OBJ, IMG_OBJ_USER_DIRECTIVE);
        DESC_OBJ_MACRO = VelocityPluginImages.createManaged(T_OBJ, IMG_OBJ_MACRO);
    }

    public static Image get(String aKey) {
        return IMAGE_REGISTRY.get(aKey);
    }

    public static void setToolImageDescriptors(IAction anAction, String anIconName) {
        VelocityPluginImages.setImageDescriptors(anAction, "tool16", anIconName);
    }

    public static void setLocalImageDescriptors(IAction anAction, String anIconName) {
        VelocityPluginImages.setImageDescriptors(anAction, "lcl16", anIconName);
    }

    private static void setImageDescriptors(IAction anAction, String aType, String aRelPath) {
        ImageDescriptor id;
        try {
            id = ImageDescriptor.createFromURL((URL)VelocityPluginImages.makeIconFileURL("d" + aType, aRelPath));
            if (id != null) {
                anAction.setDisabledImageDescriptor(id);
            }
        }
        catch (MalformedURLException malformedURLException) {}
        try {
            id = ImageDescriptor.createFromURL((URL)VelocityPluginImages.makeIconFileURL("c" + aType, aRelPath));
            if (id != null) {
                anAction.setHoverImageDescriptor(id);
            }
        }
        catch (MalformedURLException malformedURLException) {}
        anAction.setImageDescriptor(VelocityPluginImages.create("e" + aType, aRelPath));
    }

    private static ImageDescriptor createManaged(String aPrefix, String aName) {
        ImageDescriptor result = VelocityPluginImages.create(aPrefix, aName);
        IMAGE_REGISTRY.put(aName, result);
        return result;
    }

    private static ImageDescriptor create(String aPrefix, String aName) {
        ImageDescriptor result;
        try {
            result = ImageDescriptor.createFromURL((URL)VelocityPluginImages.makeIconFileURL(aPrefix, aName));
        }
        catch (MalformedURLException malformedURLException) {
            result = ImageDescriptor.getMissingImageDescriptor();
        }
        return result;
    }

    private static URL makeIconFileURL(String aPrefix, String aName) throws MalformedURLException {
        if (fgIconBaseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(aPrefix);
        buffer.append('/');
        buffer.append(aName);
        return new URL(fgIconBaseURL, buffer.toString());
    }
}

