/*
 * Decompiled with CFR 0.152.
 */
package org.vaulttec.velocity.ui.editor;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class VelocityAnnotationHover
implements IAnnotationHover {
    public String getHoverInfo(ISourceViewer aViewer, int aLine) {
        String message;
        String info = null;
        IMarker marker = this.getMarkerForLine(aViewer, aLine);
        if (marker != null && (message = marker.getAttribute("message", null)) != null && message.trim().length() > 0) {
            info = message.trim();
        }
        return info;
    }

    protected IMarker getMarkerForLine(ISourceViewer aViewer, int aLine) {
        IMarker marker = null;
        IAnnotationModel model = aViewer.getAnnotationModel();
        if (model != null) {
            Iterator e = model.getAnnotationIterator();
            while (e.hasNext()) {
                MarkerAnnotation a;
                Object o = e.next();
                if (!(o instanceof MarkerAnnotation) || this.compareRulerLine(model.getPosition((Annotation)(a = (MarkerAnnotation)o)), aViewer.getDocument(), aLine) == 0) continue;
                marker = a.getMarker();
            }
        }
        return marker;
    }

    protected int compareRulerLine(Position aPosition, IDocument aDocument, int aLine) {
        int distance = 0;
        if (aPosition.getOffset() > -1 && aPosition.getLength() > -1) {
            try {
                int markerLine = aDocument.getLineOfOffset(aPosition.getOffset());
                if (aLine == markerLine) {
                    distance = 1;
                } else if (markerLine <= aLine && aLine <= aDocument.getLineOfOffset(aPosition.getOffset() + aPosition.getLength())) {
                    distance = 2;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return distance;
    }
}

