/*
 * Decompiled with CFR 0.152.
 */
package org.vaulttec.velocity.ui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.vaulttec.velocity.ui.VelocityPluginImages;
import org.vaulttec.velocity.ui.editor.VelocityEditor;
import org.vaulttec.velocity.ui.editor.VelocityEditorEnvironment;
import org.vaulttec.velocity.ui.editor.parser.VelocityMacro;
import org.vaulttec.velocity.ui.editor.text.VelocityTextGuesser;
import org.vaulttec.velocity.ui.model.Directive;

public class VelocityCompletionProcessor
implements IContentAssistProcessor {
    private VelocityEditor fEditor;
    private boolean fCompleteDirectives;
    private static Comparator<CompletionProposal> PROPOSAL_COMPARATOR = new Comparator<CompletionProposal>(){

        @Override
        public int compare(CompletionProposal aProposal1, CompletionProposal aProposal2) {
            String text1 = aProposal1.getDisplayString();
            String text2 = aProposal2.getDisplayString();
            return text1.compareTo(text2);
        }

        @Override
        public boolean equals(Object aProposal) {
            return false;
        }
    };

    public VelocityCompletionProcessor(VelocityEditor anEditor, boolean aCompleteDirectives) {
        this.fEditor = anEditor;
        this.fCompleteDirectives = aCompleteDirectives;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer aViewer, int anOffset) {
        ICompletionProposal[] proposals = null;
        IDocument doc = aViewer.getDocument();
        VelocityTextGuesser prefix = new VelocityTextGuesser(doc, anOffset, false);
        if (prefix.getType() == 1) {
            if (this.fCompleteDirectives) {
                proposals = this.getDirectiveProposals(prefix.getText(), anOffset - prefix.getText().length());
            }
        } else if (prefix.getType() == 2) {
            proposals = this.getVariableProposals(prefix.getText(), anOffset - prefix.getText().length());
        }
        return proposals;
    }

    private ICompletionProposal[] getDirectiveProposals(String aPrefix, int anOffset) {
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        String[] directives = Directive.DIRECTIVES;
        int i = directives.length - 1;
        while (i >= 0) {
            String directive = directives[i];
            if (directive.substring(1).startsWith(aPrefix)) {
                int cursorPos;
                if (i == 2 || i == 4 || i == 9) {
                    cursorPos = directive.length() - 1;
                } else {
                    directive = String.valueOf(directive) + "()";
                    cursorPos = directive.length() - 2;
                }
                proposals.add(new CompletionProposal(directive.substring(1), anOffset, aPrefix.length(), cursorPos, VelocityPluginImages.get("system_directive_obj.gif"), directive, null, null));
            }
            --i;
        }
        for (VelocityMacro macro : VelocityEditorEnvironment.getParser().getLibraryMacros()) {
            int cursorPos;
            String name = macro.getName();
            if (!name.startsWith(aPrefix)) continue;
            String insert = String.valueOf(name) + "()";
            StringBuffer buffer = new StringBuffer();
            buffer.append('#');
            buffer.append(name);
            buffer.append('(');
            if (macro.getArguments().length == 1) {
                cursorPos = insert.length();
                buffer.append(')');
            } else {
                cursorPos = insert.length() - 1;
                String[] args = macro.getArguments();
                int i2 = 1;
                while (i2 < args.length) {
                    buffer.append('$');
                    buffer.append(args[i2]);
                    if (i2 < args.length - 1) {
                        buffer.append(" ");
                    }
                    ++i2;
                }
                buffer.append(')');
            }
            buffer.append(" - ");
            buffer.append(macro.getTemplate());
            proposals.add(new CompletionProposal(insert, anOffset, aPrefix.length(), cursorPos, VelocityPluginImages.get("macro_obj.gif"), buffer.toString(), null, null));
        }
        for (String directive : VelocityEditorEnvironment.getParser().getUserDirectives()) {
            if (!directive.substring(1).startsWith(aPrefix)) continue;
            directive = String.valueOf(directive) + "()";
            int cursorPos = directive.length() - 1;
            proposals.add(new CompletionProposal(directive.substring(1), anOffset, aPrefix.length(), cursorPos, VelocityPluginImages.get("user_directive_obj.gif"), directive, null, null));
        }
        Collections.sort(proposals, PROPOSAL_COMPARATOR);
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private ICompletionProposal[] getVariableProposals(String aPrefix, int anOffset) {
        ICompletionProposal[] result = null;
        List<String> variables = this.fEditor.getVariables(this.fEditor.getLine(anOffset));
        if (!variables.isEmpty()) {
            ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
            for (String variable : variables) {
                if (!variable.substring(1).startsWith(aPrefix)) continue;
                proposals.add(new CompletionProposal(variable.substring(1), anOffset, aPrefix.length(), variable.length() - 1, null, variable, null, null));
            }
            Collections.sort(proposals, PROPOSAL_COMPARATOR);
            result = proposals.toArray(new ICompletionProposal[proposals.size()]);
        }
        return result;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'#', '$'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }
}

