/*
 * Decompiled with CFR 0.152.
 */
package org.vaulttec.velocity.ui.editor;

import java.util.Vector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.vaulttec.velocity.ui.VelocityColorProvider;
import org.vaulttec.velocity.ui.editor.VelocityAnnotationHover;
import org.vaulttec.velocity.ui.editor.VelocityCompletionProcessor;
import org.vaulttec.velocity.ui.editor.VelocityEditor;
import org.vaulttec.velocity.ui.editor.VelocityEditorEnvironment;
import org.vaulttec.velocity.ui.editor.VelocityTextHover;
import org.vaulttec.velocity.ui.editor.text.NonRuleBasedDamagerRepairer;
import org.vaulttec.velocity.ui.editor.text.VelocityPartitionScanner;
import org.vaulttec.velocity.ui.preferences.JavaPreferenceHelper;

public class VelocityConfiguration
extends SourceViewerConfiguration {
    private VelocityEditor fEditor;

    public VelocityConfiguration(VelocityEditor anEditor) {
        this.fEditor = anEditor;
    }

    public String[] getConfiguredContentTypes(ISourceViewer aSourceViewer) {
        return VelocityPartitionScanner.TYPES;
    }

    public ITextHover getTextHover(ISourceViewer aSourceViewer, String aContentType) {
        VelocityTextHover hover = aContentType.equals("__dftl_partition_content_type") || aContentType.equals("__parsed_string") ? new VelocityTextHover(this.fEditor) : null;
        return hover;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer aSourceViewer) {
        return new VelocityAnnotationHover();
    }

    public IContentAssistant getContentAssistant(ISourceViewer aSourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor((IContentAssistProcessor)new VelocityCompletionProcessor(this.fEditor, true), "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)new VelocityCompletionProcessor(this.fEditor, false), "__parsed_string");
        assistant.enableAutoInsert(true);
        assistant.enableAutoActivation(true);
        return assistant;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer aSourceViewer, String aContentType) {
        return VelocityEditorEnvironment.getDoubleClickStrategy();
    }

    public String[] getDefaultPrefixes(ISourceViewer aSourceViewer, String aContentType) {
        return new String[]{"##", ""};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer aSourceViewer) {
        VelocityColorProvider cp = VelocityEditorEnvironment.getColorProvider();
        PresentationReconciler rec = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)VelocityEditorEnvironment.getCodeScanner());
        rec.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        rec.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(cp.getColor("comment")));
        rec.setDamager((IPresentationDamager)ndr, "__singleline_comment");
        rec.setRepairer((IPresentationRepairer)ndr, "__singleline_comment");
        ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(cp.getColor("comment")));
        rec.setDamager((IPresentationDamager)ndr, "__multiline_comment");
        rec.setRepairer((IPresentationRepairer)ndr, "__multiline_comment");
        ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(cp.getColor("doc_comment")));
        rec.setDamager((IPresentationDamager)ndr, "__doc_comment");
        rec.setRepairer((IPresentationRepairer)ndr, "__doc_comment");
        ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(cp.getColor("string")));
        rec.setDamager((IPresentationDamager)ndr, "__unparsed_string");
        rec.setRepairer((IPresentationRepairer)ndr, "__unparsed_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)VelocityEditorEnvironment.getStringScanner());
        rec.setDamager((IPresentationDamager)dr, "__parsed_string");
        rec.setRepairer((IPresentationRepairer)dr, "__parsed_string");
        return rec;
    }

    public IReconciler getReconciler(ISourceViewer aSourceViewer) {
        return new MonoReconciler((IReconcilingStrategy)this.fEditor.getReconcilingStrategy(), false);
    }

    public String[] getIndentPrefixes(ISourceViewer aSourceViewer, String aContentType) {
        Vector<String> prefixes = new Vector<String>();
        int tabWidth = this.getTabWidth(aSourceViewer);
        IPreferenceStore prefs = JavaPreferenceHelper.getJavaPreferneceStore();
        boolean useSpaces = prefs.getBoolean("org.eclipse.jdt.core.formatter.tabulation.char");
        int i = 0;
        while (i <= tabWidth) {
            int j;
            StringBuffer prefix = new StringBuffer();
            if (useSpaces) {
                j = 0;
                while (j + i < tabWidth) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != 0) {
                    prefix.append('\t');
                }
            } else {
                j = 0;
                while (j < i) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != tabWidth) {
                    prefix.append('\t');
                }
            }
            prefixes.add(prefix.toString());
            ++i;
        }
        prefixes.add("");
        return prefixes.toArray(new String[prefixes.size()]);
    }

    public int getTabWidth(ISourceViewer aSourceViewer) {
        return 4;
    }
}

