/*
 * Decompiled with CFR 0.152.
 */
package org.vaulttec.velocity.ui.editor;

import com.langtags.ep4velo.Activator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.vaulttec.velocity.ui.editor.VelocityConfiguration;
import org.vaulttec.velocity.ui.editor.VelocityDocumentProvider;
import org.vaulttec.velocity.ui.editor.VelocityEditorEnvironment;
import org.vaulttec.velocity.ui.editor.VelocityReconcilingStrategy;
import org.vaulttec.velocity.ui.editor.actions.GotoDefinitionAction;
import org.vaulttec.velocity.ui.editor.outline.VelocityOutlinePage;
import org.vaulttec.velocity.ui.editor.parser.VelocityMacro;
import org.vaulttec.velocity.ui.editor.text.VelocityTextGuesser;
import org.vaulttec.velocity.ui.model.ITreeNode;
import org.vaulttec.velocity.ui.model.ModelTools;

public class VelocityEditor
extends TextEditor {
    private static final String PREFIX = "VelocityEditor.";
    private ModelTools fModelTools = new ModelTools(this);
    private VelocityReconcilingStrategy fReconcilingStrategy = new VelocityReconcilingStrategy(this);
    private VelocityOutlinePage fOutlinePage;
    private int fLastCursorLine;

    protected void initializeEditor() {
        super.initializeEditor();
        VelocityEditorEnvironment.connect();
        this.setDocumentProvider((IDocumentProvider)new VelocityDocumentProvider());
        this.setSourceViewerConfiguration(new VelocityConfiguration(this));
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.vaulttec.velocity.ui.velocityEditorScope"});
    }

    protected void createActions() {
        super.createActions();
        GotoDefinitionAction action = new GotoDefinitionAction(Activator.getResourceBundle(), "VelocityEditor.GotoDefinition.", (ITextEditor)this);
        action.setActionDefinitionId("org.vaulttec.velocity.ui.edit.goto.definition");
        this.setAction("GotoDefinition", (IAction)action);
        action = new ContentAssistAction(Activator.getResourceBundle(), "VelocityEditor.ContentAssist.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssist", (IAction)action);
        action = new TextOperationAction(Activator.getResourceBundle(), "VelocityEditor.Comment.", (ITextEditor)this, 11);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.comment");
        this.setAction("Comment", (IAction)action);
        action = new TextOperationAction(Activator.getResourceBundle(), "VelocityEditor.Uncomment.", (ITextEditor)this, 12);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.uncomment");
        this.setAction("Uncomment", (IAction)action);
    }

    public Object getAdapter(Class aClass) {
        Object adapter;
        if (aClass.equals(IContentOutlinePage.class)) {
            if (this.fOutlinePage == null || this.fOutlinePage.isDisposed()) {
                this.fOutlinePage = new VelocityOutlinePage(this);
                if (this.getEditorInput() != null) {
                    this.fOutlinePage.setInput(this.getEditorInput());
                }
            }
            adapter = this.fOutlinePage;
        } else {
            adapter = super.getAdapter(aClass);
        }
        return adapter;
    }

    public void dispose() {
        if (this.fOutlinePage != null && !this.fOutlinePage.isDisposed()) {
            this.fOutlinePage.dispose();
            this.fOutlinePage = null;
        }
        VelocityEditorEnvironment.disconnect();
        super.dispose();
    }

    protected void editorContextMenuAboutToShow(IMenuManager aMenu) {
        super.editorContextMenuAboutToShow(aMenu);
        this.addAction(aMenu, "additions", "GotoDefinition");
        this.addAction(aMenu, "additions", "Comment");
        this.addAction(aMenu, "additions", "Uncomment");
    }

    protected void handleCursorPositionChanged() {
        super.handleCursorPositionChanged();
        int line = this.getCursorLine();
        if (line > 0 && line != this.fLastCursorLine) {
            this.fLastCursorLine = line;
            if (this.fOutlinePage != null && !this.fOutlinePage.isDisposed()) {
                this.fOutlinePage.selectNode(line, false);
            }
        }
    }

    public IDocument getDocument() {
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer != null) {
            return viewer.getDocument();
        }
        return null;
    }

    public int getLine(int anOffset) {
        int line;
        try {
            line = this.getDocument().getLineOfOffset(anOffset) + 1;
        }
        catch (BadLocationException badLocationException) {
            line = -1;
        }
        return line;
    }

    public int getCursorLine() {
        int line = -1;
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer != null) {
            StyledText styledText = sourceViewer.getTextWidget();
            int caret = VelocityEditor.widgetOffset2ModelOffset((ISourceViewer)sourceViewer, (int)styledText.getCaretOffset());
            IDocument document = sourceViewer.getDocument();
            if (document != null) {
                try {
                    line = document.getLineOfOffset(caret) + 1;
                }
                catch (BadLocationException e) {
                    Activator.log(e);
                }
            }
        }
        return line;
    }

    public void highlightNode(ITreeNode aNode, boolean aMoveCursor) {
        IDocument doc = this.getDocument();
        try {
            int offset = doc.getLineOffset(aNode.getStartLine() - 1);
            IRegion endLine = doc.getLineInformation(aNode.getEndLine() - 1);
            int length = endLine.getOffset() + endLine.getLength() - offset;
            this.setHighlightRange(offset, length + 1, aMoveCursor);
        }
        catch (BadLocationException badLocationException) {
            this.resetHighlightRange();
        }
    }

    public void revealNode(ITreeNode aNode) {
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer != null) {
            IDocument doc = this.getDocument();
            try {
                int offset = doc.getLineOffset(aNode.getStartLine() - 1);
                IRegion endLine = doc.getLineInformation(aNode.getEndLine() - 1);
                int length = endLine.getOffset() + endLine.getLength() - offset;
                StyledText widget = this.getSourceViewer().getTextWidget();
                widget.setRedraw(false);
                viewer.revealRange(offset, length);
                widget.setRedraw(true);
            }
            catch (BadLocationException badLocationException) {
                this.resetHighlightRange();
            }
        }
    }

    public ITreeNode getNodeByLine(int aLine) {
        return this.fModelTools.getNodeByLine(aLine);
    }

    public String getDefinitionLine(IRegion aRegion) {
        if (aRegion != null) {
            ITreeNode node;
            VelocityMacro macro;
            VelocityTextGuesser guess = new VelocityTextGuesser(this.getDocument(), aRegion.getOffset(), true);
            if (guess.getType() == 1 && (macro = VelocityEditorEnvironment.getParser().getLibraryMacro(guess.getText())) != null) {
                String template = ((IFileEditorInput)this.getEditorInput()).getFile().getName();
                if (!macro.getTemplate().equals(template)) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("#macro (");
                    buf.append(macro.getName());
                    buf.append(") - ");
                    buf.append(macro.getTemplate());
                    return buf.toString();
                }
            }
            if ((node = this.fModelTools.getNodeByGuess(guess)) != null) {
                IDocument doc = this.getDocument();
                try {
                    aRegion = doc.getLineInformation(node.getStartLine() - 1);
                    StringBuffer buf = new StringBuffer();
                    buf.append(node.getStartLine());
                    buf.append(": ");
                    buf.append(doc.get(aRegion.getOffset(), aRegion.getLength()).trim());
                    return buf.toString();
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        return null;
    }

    public void gotoDefinition(IRegion aRegion) {
        if (aRegion != null) {
            ITreeNode node;
            VelocityMacro macro;
            VelocityTextGuesser guess = new VelocityTextGuesser(this.getDocument(), aRegion.getOffset(), true);
            if (guess.getType() == 1 && (macro = VelocityEditorEnvironment.getParser().getLibraryMacro(guess.getText())) != null) {
                String template = ((IFileEditorInput)this.getEditorInput()).getFile().getName();
                if (!macro.getTemplate().equals(template)) {
                    return;
                }
            }
            if ((node = this.fModelTools.getNodeByGuess(guess)) != null) {
                this.markInNavigationHistory();
                this.highlightNode(node, true);
                this.markInNavigationHistory();
            }
        }
    }

    public boolean isLineWithinLoop(int aLine) {
        return this.fModelTools.isLineWithinLoop(aLine);
    }

    public List<String> getVariables(int aLine) {
        return this.fModelTools.getVariables(aLine);
    }

    public List<String> getMacros() {
        return this.fModelTools.getMacros();
    }

    public VelocityReconcilingStrategy getReconcilingStrategy() {
        return this.fReconcilingStrategy;
    }

    public Object[] getRootElements() {
        return this.fReconcilingStrategy.getRootElements();
    }

    public ITreeNode getRootNode() {
        return this.fReconcilingStrategy.getRootNode();
    }

    public ITreeNode getLastRootNode() {
        return this.fReconcilingStrategy.getLastRootNode();
    }

    public void updateOutlinePage() {
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    public void moveCursor(int aLine) {
        ISourceViewer sourceViewer = this.getSourceViewer();
        try {
            int offset = this.getDocument().getLineOffset(aLine - 1);
            sourceViewer.setSelectedRange(offset, 0);
            sourceViewer.revealRange(offset, 0);
        }
        catch (BadLocationException badLocationException) {}
    }

    public static boolean isReferencePart(char aChar) {
        return Character.isLetterOrDigit(aChar) || aChar == '-' || aChar == '_';
    }

    protected IStatusLineManager getStatusLineManager() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        IStatusLineManager manager = contributor != null && contributor instanceof EditorActionBarContributor ? ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager() : null;
        return manager;
    }

    public void displayErrorMessage(String aMessage) {
        IStatusLineManager manager = this.getStatusLineManager();
        if (manager != null) {
            manager.setErrorMessage(aMessage);
        }
    }

    public void addProblemMarker(String aMessage, int aLine) {
        IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
        try {
            IMarker marker = file.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("severity", 2);
            marker.setAttribute("message", (Object)aMessage);
            marker.setAttribute("lineNumber", aLine);
            Position pos = new Position(this.getDocument().getLineOffset(aLine - 1));
            this.getSourceViewer().getAnnotationModel().addAnnotation((Annotation)new MarkerAnnotation(marker), pos);
        }
        catch (Exception e) {
            Activator.log(e);
        }
    }
}

