/*
 * Decompiled with CFR 0.152.
 */
package org.vaulttec.velocity.ui.editor;

import com.langtags.ep4velo.Activator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.texteditor.BasicTextEditorActionContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;
import org.vaulttec.velocity.ui.editor.actions.TogglePresentationAction;

public class VelocityEditorActionContributor
extends BasicTextEditorActionContributor {
    private static final String PREFIX = "VelocityEditor.";
    private TogglePresentationAction fTogglePresentation;
    private RetargetTextEditorAction fGotoDefinition;
    private RetargetTextEditorAction fContentAssist;
    private RetargetTextEditorAction fComment;
    private RetargetTextEditorAction fUncomment;

    public VelocityEditorActionContributor() {
        this.createActions();
    }

    protected void createActions() {
        this.fTogglePresentation = new TogglePresentationAction();
        this.fGotoDefinition = new RetargetTextEditorAction(Activator.getResourceBundle(), "VelocityEditor.GotoDefinition.");
        this.fGotoDefinition.setActionDefinitionId("org.vaulttec.velocity.ui.edit.goto.definition");
        this.fContentAssist = new RetargetTextEditorAction(Activator.getResourceBundle(), "VelocityEditor.ContentAssist.");
        this.fContentAssist.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.fComment = new RetargetTextEditorAction(Activator.getResourceBundle(), "VelocityEditor.Comment.");
        this.fComment.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.comment");
        this.fUncomment = new RetargetTextEditorAction(Activator.getResourceBundle(), "VelocityEditor.Uncomment.");
        this.fUncomment.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.uncomment");
    }

    public void setActiveEditor(IEditorPart aPart) {
        super.setActiveEditor(aPart);
        this.doSetActiveEditor(aPart);
    }

    private void doSetActiveEditor(IEditorPart aPart) {
        IStatusLineManager manager = this.getActionBars().getStatusLineManager();
        manager.setMessage(null);
        manager.setErrorMessage(null);
        ITextEditor editor = null;
        if (aPart instanceof ITextEditor) {
            editor = (ITextEditor)aPart;
        }
        this.fTogglePresentation.setEditor(editor);
        this.fGotoDefinition.setAction(this.getAction(editor, "GotoDefinition"));
        this.fContentAssist.setAction(this.getAction(editor, "ContentAssist"));
        this.fComment.setAction(this.getAction(editor, "Comment"));
        this.fUncomment.setAction(this.getAction(editor, "Uncomment"));
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null) {
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.getAction(editor, ITextEditorActionConstants.DELETE));
            actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.getAction(editor, ITextEditorActionConstants.UNDO));
            actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.getAction(editor, ITextEditorActionConstants.REDO));
            actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.getAction(editor, ITextEditorActionConstants.CUT));
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.getAction(editor, ITextEditorActionConstants.COPY));
            actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.getAction(editor, ITextEditorActionConstants.PASTE));
            actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.getAction(editor, ITextEditorActionConstants.SELECT_ALL));
            actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.getAction(editor, ITextEditorActionConstants.FIND));
            actionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), this.getAction(editor, IDEActionFactory.BOOKMARK.getId()));
            actionBars.setGlobalActionHandler(IDEActionFactory.ADD_TASK.getId(), this.getAction(editor, IDEActionFactory.ADD_TASK.getId()));
            actionBars.setGlobalActionHandler("GotoLine", this.getAction(editor, "org.eclipse.ui.edit.text.goto.line"));
            actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.edit.text.java.comment", this.getAction(editor, "Comment"));
            actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.edit.text.java.uncomment", this.getAction(editor, "Uncomment"));
            actionBars.setGlobalActionHandler("GotoDefinition", this.getAction(editor, "GotoDefinition"));
            actionBars.updateActionBars();
        }
    }

    public void contributeToMenu(IMenuManager aMenuManager) {
        super.contributeToMenu(aMenuManager);
        IMenuManager menu = aMenuManager.findMenuUsingPath("edit");
        if (menu != null) {
            menu.add((IAction)this.fContentAssist);
            menu.add((IAction)this.fComment);
            menu.add((IAction)this.fUncomment);
        }
        if ((menu = aMenuManager.findMenuUsingPath("navigate")) != null) {
            menu.appendToGroup("additions", (IAction)this.fGotoDefinition);
        }
    }

    public void contributeToToolBar(IToolBarManager aToolBar) {
        aToolBar.add((IContributionItem)new Separator());
        aToolBar.add((IAction)this.fTogglePresentation);
    }

    public void dispose() {
        this.doSetActiveEditor(null);
        super.dispose();
    }
}

