/*
 * Decompiled with CFR 0.152.
 */
package org.vaulttec.velocity.ui.editor;

import com.langtags.ep4velo.Activator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.vaulttec.velocity.ui.VelocityColorProvider;
import org.vaulttec.velocity.ui.editor.parser.VelocityParser;
import org.vaulttec.velocity.ui.editor.text.VelocityCodeScanner;
import org.vaulttec.velocity.ui.editor.text.VelocityDoubleClickStrategy;
import org.vaulttec.velocity.ui.editor.text.VelocityStringScanner;

public class VelocityEditorEnvironment {
    private static VelocityParser fgVelocityParser;
    private static VelocityColorProvider fgColorProvider;
    private static RuleBasedScanner fgCodeScanner;
    private static RuleBasedScanner fgStringScanner;
    private static ITextDoubleClickStrategy fgDoubleClickStrategy;
    private static int fgRefCount;

    static {
        fgRefCount = 0;
    }

    public static void connect() {
        if (++fgRefCount == 1) {
            VelocityEditorEnvironment.createVelocityParser();
            fgColorProvider = new VelocityColorProvider();
            fgCodeScanner = new VelocityCodeScanner(fgColorProvider);
            fgStringScanner = new VelocityStringScanner(fgColorProvider);
            fgDoubleClickStrategy = new VelocityDoubleClickStrategy();
        }
    }

    public static void createVelocityParser() {
        if (fgRefCount > 0) {
            fgVelocityParser = new VelocityParser();
            try {
                fgVelocityParser.init();
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
    }

    public static void disconnect() {
        if (--fgRefCount == 0) {
            fgDoubleClickStrategy = null;
            fgStringScanner = null;
            fgCodeScanner = null;
            fgColorProvider.dispose();
            fgColorProvider = null;
            fgVelocityParser = null;
        }
    }

    public static VelocityColorProvider getColorProvider() {
        return fgColorProvider;
    }

    public static RuleBasedScanner getCodeScanner() {
        return fgCodeScanner;
    }

    public static RuleBasedScanner getStringScanner() {
        return fgStringScanner;
    }

    public static ITextDoubleClickStrategy getDoubleClickStrategy() {
        return fgDoubleClickStrategy;
    }

    public static VelocityParser getParser() {
        return fgVelocityParser;
    }
}

