/*
 * Decompiled with CFR 0.152.
 */
package org.vaulttec.velocity.ui.editor;

import com.langtags.ep4velo.Activator;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.ParserVisitor;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IFileEditorInput;
import org.vaulttec.velocity.ui.editor.VelocityEditor;
import org.vaulttec.velocity.ui.editor.VelocityEditorEnvironment;
import org.vaulttec.velocity.ui.editor.parser.NodeVisitor;
import org.vaulttec.velocity.ui.editor.parser.VelocityParser;
import org.vaulttec.velocity.ui.model.ITreeNode;
import org.vaulttec.velocity.ui.model.Template;

public class VelocityReconcilingStrategy
implements IReconcilingStrategy {
    private VelocityEditor fEditor;
    private Template fTemplate;
    private Template fLastTemplate;
    private String fError;

    public VelocityReconcilingStrategy(VelocityEditor anEditor) {
        this.fEditor = anEditor;
    }

    public void setDocument(IDocument aDocument) {
        this.parse();
    }

    public void reconcile(DirtyRegion aDirtyRegion, IRegion aRegion) {
        this.parse();
    }

    public void reconcile(IRegion aPartition) {
        this.parse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() {
        Template template;
        block23: {
            IFile file = ((IFileEditorInput)this.fEditor.getEditorInput()).getFile();
            String name = file.getName();
            StringReader reader = new StringReader(this.fEditor.getDocument().get());
            template = null;
            try {
                file.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                VelocityParser runtime = VelocityEditorEnvironment.getParser();
                SimpleNode root = runtime.parse(reader, name);
                NodeVisitor visitor = new NodeVisitor(name);
                root.jjtAccept((ParserVisitor)visitor, null);
                template = visitor.getTemplate();
                this.fError = "";
            }
            catch (ParseException e) {
                if (e.getMessage() != null) {
                    this.fError = e.getMessage();
                    Token token = e.currentToken;
                    if (token != null) {
                        this.fEditor.addProblemMarker(e.getMessage(), token.next.beginLine);
                    }
                } else {
                    this.fError = "";
                }
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e2) {
                    Activator.log(e2);
                }
                break block23;
            }
            catch (Exception e) {
                try {
                    this.fError = "";
                    Activator.log(e);
                    break block23;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (IOException e3) {
                        Activator.log(e3);
                    }
                }
            }
            try {
                ((Reader)reader).close();
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
        VelocityReconcilingStrategy velocityReconcilingStrategy = this;
        synchronized (velocityReconcilingStrategy) {
            if (template != null) {
                this.fTemplate = template;
                this.fLastTemplate = template;
            } else {
                this.fTemplate = null;
            }
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                VelocityReconcilingStrategy.this.fEditor.updateOutlinePage();
                VelocityReconcilingStrategy.this.fEditor.displayErrorMessage(VelocityReconcilingStrategy.this.fError);
            }
        });
    }

    public Object[] getRootElements() {
        return this.fTemplate != null ? this.fTemplate.getChildren() : ITreeNode.NO_CHILDREN;
    }

    public ITreeNode getRootNode() {
        return this.fTemplate;
    }

    public ITreeNode getLastRootNode() {
        return this.fLastTemplate;
    }
}

