/*
 * Decompiled with CFR 0.152.
 */
package org.vaulttec.velocity.ui.editor.actions;

import com.langtags.ep4velo.Activator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.vaulttec.velocity.ui.VelocityPluginImages;

public class TogglePresentationAction
extends TextEditorAction {
    public TogglePresentationAction() {
        super(Activator.getResourceBundle(), "VelocityEditor.TogglePresentation.", null);
        VelocityPluginImages.setToolImageDescriptors((IAction)this, "segment_edit.gif");
        this.setToolTipText(Activator.getMessage("VelocityEditor.TogglePresentation.tooltip"));
        this.update();
    }

    public void run() {
        ITextEditor editor = this.getTextEditor();
        if (editor != null) {
            IRegion remembered = editor.getHighlightRange();
            editor.resetHighlightRange();
            boolean showAll = !editor.showsHighlightRangeOnly();
            this.setChecked(showAll);
            editor.showHighlightRangeOnly(showAll);
            if (remembered != null) {
                editor.setHighlightRange(remembered.getOffset(), remembered.getLength(), true);
            }
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            store.setValue("com.langtags.ep4velo.editor.showSegments", showAll);
        }
    }

    public void update() {
        ITextEditor editor = this.getTextEditor();
        boolean checked = editor != null && editor.showsHighlightRangeOnly();
        this.setChecked(checked);
        this.setEnabled(editor != null);
    }

    public void setEditor(ITextEditor anEditor) {
        super.setEditor(anEditor);
        if (anEditor != null) {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            boolean showSegments = store.getBoolean("com.langtags.ep4velo.editor.showSegments");
            if (anEditor.showsHighlightRangeOnly() != showSegments) {
                IRegion remembered = anEditor.getHighlightRange();
                anEditor.resetHighlightRange();
                anEditor.showHighlightRangeOnly(showSegments);
                if (remembered != null) {
                    anEditor.setHighlightRange(remembered.getOffset(), remembered.getLength(), true);
                }
            }
            this.update();
        }
    }
}

