/*
 * Decompiled with CFR 0.152.
 */
package org.vaulttec.velocity.ui.editor.outline;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.vaulttec.velocity.ui.editor.VelocityEditor;
import org.vaulttec.velocity.ui.editor.actions.CollapseAllAction;
import org.vaulttec.velocity.ui.editor.outline.VelocityOutlineContentProvider;
import org.vaulttec.velocity.ui.editor.outline.VelocityOutlineLabelProvider;
import org.vaulttec.velocity.ui.model.ITreeNode;

public class VelocityOutlinePage
extends ContentOutlinePage {
    private VelocityEditor fEditor;
    private Object fInput;
    private String fSelectedNodeID;
    private VelocityOutlineLabelProvider fLabelProvider;
    private boolean fIsDisposed;

    public VelocityOutlinePage(VelocityEditor anEditor) {
        this.fEditor = anEditor;
        this.fIsDisposed = true;
    }

    public void createControl(Composite aParent) {
        super.createControl(aParent);
        this.fLabelProvider = new VelocityOutlineLabelProvider();
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new VelocityOutlineContentProvider(this.fEditor));
        viewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.fInput != null) {
            viewer.setInput(this.fInput);
        }
        this.fIsDisposed = false;
        IToolBarManager mgr = this.getSite().getActionBars().getToolBarManager();
        mgr.add((IAction)new CollapseAllAction((AbstractTreeViewer)viewer));
        this.update();
    }

    public void selectionChanged(SelectionChangedEvent anEvent) {
        super.selectionChanged(anEvent);
        ISelection selection = anEvent.getSelection();
        if (!selection.isEmpty()) {
            ITreeNode node = (ITreeNode)((IStructuredSelection)selection).getFirstElement();
            if (this.fSelectedNodeID == null || this.isDifferentBlock(node)) {
                this.fEditor.highlightNode(node, true);
                this.fSelectedNodeID = node.getUniqueID();
            } else {
                this.fEditor.revealNode(node);
            }
        }
    }

    public void selectNode(int aLine, boolean aForceSelect) {
        if (aLine > 0) {
            TreeViewer viewer = this.getTreeViewer();
            ITreeNode node = this.fEditor.getNodeByLine(aLine);
            viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            if (node == null) {
                if (this.fSelectedNodeID != null) {
                    viewer.setSelection((ISelection)new StructuredSelection());
                    this.fEditor.resetHighlightRange();
                    this.fSelectedNodeID = null;
                }
            } else {
                if (aForceSelect || this.isDifferentBlock(node)) {
                    viewer.setSelection((ISelection)new StructuredSelection((Object)node));
                    this.fEditor.highlightNode(node, false);
                    this.fSelectedNodeID = node.getUniqueID();
                }
                viewer.reveal((Object)node);
            }
            viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    private boolean isDifferentBlock(ITreeNode aNode) {
        return this.fSelectedNodeID == null || !this.fSelectedNodeID.equals(aNode.getUniqueID());
    }

    public void setInput(Object aInput) {
        this.fInput = aInput;
        this.update();
    }

    public void update() {
        Control control;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            control.setRedraw(false);
            viewer.setInput(this.fInput);
            control.setRedraw(true);
            this.selectNode(this.fEditor.getCursorLine(), true);
            viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public void dispose() {
        this.setInput(null);
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
            this.fLabelProvider = null;
        }
        this.fIsDisposed = true;
        super.dispose();
    }

    public boolean isDisposed() {
        return this.fIsDisposed;
    }
}

