/*
 * Decompiled with CFR 0.152.
 */
package org.vaulttec.velocity.ui.editor.parser;

import com.langtags.ep4velo.Activator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.Parser;
import org.eclipse.jface.preference.IPreferenceStore;
import org.vaulttec.velocity.ui.editor.parser.VelocityDirective;
import org.vaulttec.velocity.ui.editor.parser.VelocityMacro;

public class VelocityParser
extends RuntimeInstance {
    private boolean fIsInitialized = false;
    private Hashtable<String, Directive> fDirectives;
    private List<String> fUserDirectives;
    private Hashtable<String, VelocityMacro> fMacros = new Hashtable();

    public Collection<String> getUserDirectives() {
        return this.fUserDirectives;
    }

    public VelocityMacro getLibraryMacro(String aName) {
        return this.fMacros.containsKey(aName) ? this.fMacros.get(aName) : null;
    }

    public Collection<VelocityMacro> getLibraryMacros() {
        return this.fMacros.values();
    }

    public boolean isUserDirective(String aName) {
        return this.fUserDirectives.contains(aName);
    }

    public synchronized void init() {
        if (!this.fIsInitialized) {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            this.setProperty("file.resource.loader.path", store.getString("com.langtags.ep4velo.library.path"));
            this.setProperty("velocimacro.library", store.getString("com.langtags.ep4velo.library.list"));
            try {
                this.initializeDirectives();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            super.init();
            this.fIsInitialized = true;
        }
    }

    public Parser createNewParser() {
        Parser parser = super.createNewParser();
        return parser;
    }

    private void initializeDirectives() throws Exception {
        this.fDirectives = new Hashtable();
        Properties directiveProperties = new Properties();
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("org/apache/velocity/runtime/defaults/directive.properties");
        if (inputStream == null) {
            throw new Exception("Error loading directive.properties! Something is very wrong if these properties aren't being located. Either your Velocity distribution is incomplete or your Velocity jar file is corrupted!");
        }
        directiveProperties.load(inputStream);
        Enumeration<Object> directiveClasses = directiveProperties.elements();
        while (directiveClasses.hasMoreElements()) {
            String directiveClass = (String)directiveClasses.nextElement();
            this.loadDirective(directiveClass, "System");
        }
        this.fUserDirectives = new ArrayList<String>();
        for (String directive : Activator.getVelocityUserDirectives()) {
            String name = directive.substring(0, directive.indexOf(32));
            int type = directive.endsWith("[Block]") ? 1 : 2;
            this.fUserDirectives.add(String.valueOf('#') + name);
            this.fDirectives.put(name, new VelocityDirective(name, type));
        }
    }

    private void loadDirective(String directiveClass, String caption) {
        try {
            Object o = Class.forName(directiveClass).newInstance();
            if (o instanceof Directive) {
                Directive directive = (Directive)o;
                this.fDirectives.put(directive.getName(), directive);
                this.getLog().info((Object)("Loaded " + caption + " Directive: " + directiveClass));
            } else {
                this.getLog().error((Object)(String.valueOf(caption) + " Directive " + directiveClass + " is not org.apache.velocity.runtime.directive.Directive." + " Ignoring. "));
            }
        }
        catch (Exception e) {
            this.getLog().error((Object)("Exception Loading " + caption + " Directive: " + directiveClass + " : " + e));
        }
    }

    public boolean addVelocimacro(String name, String macro, String[] argArray, String sourceTemplate) {
        this.fMacros.put(name, new VelocityMacro(name, argArray, sourceTemplate));
        return super.addVelocimacro(name, macro, argArray, sourceTemplate);
    }
}

