/*
 * Decompiled with CFR 0.152.
 */
package org.vaulttec.velocity.ui.editor.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.swt.custom.StyleRange;

public class NonRuleBasedDamagerRepairer
implements IPresentationDamager,
IPresentationRepairer {
    protected IDocument fDocument;
    protected TextAttribute fDefaultTextAttribute;

    public NonRuleBasedDamagerRepairer(TextAttribute aDefaultTextAttribute) {
        Assert.isNotNull((Object)aDefaultTextAttribute);
        this.fDefaultTextAttribute = aDefaultTextAttribute;
    }

    public void setDocument(IDocument aDocument) {
        this.fDocument = aDocument;
    }

    protected int endOfLineOf(int anOffset) throws BadLocationException {
        IRegion info = this.fDocument.getLineInformationOfOffset(anOffset);
        if (anOffset <= info.getOffset() + info.getLength()) {
            return info.getOffset() + info.getLength();
        }
        int line = this.fDocument.getLineOfOffset(anOffset);
        try {
            info = this.fDocument.getLineInformation(line + 1);
            return info.getOffset() + info.getLength();
        }
        catch (BadLocationException badLocationException) {
            return this.fDocument.getLength();
        }
    }

    public IRegion getDamageRegion(ITypedRegion aPartition, DocumentEvent anEvent, boolean aDocumentPartitioningChanged) {
        if (!aDocumentPartitioningChanged) {
            try {
                IRegion info = this.fDocument.getLineInformationOfOffset(anEvent.getOffset());
                int start = Math.max(aPartition.getOffset(), info.getOffset());
                int end = anEvent.getOffset() + (anEvent.getText() == null ? anEvent.getLength() : anEvent.getText().length());
                end = info.getOffset() <= end && end <= info.getOffset() + info.getLength() ? info.getOffset() + info.getLength() : this.endOfLineOf(end);
                end = Math.min(aPartition.getOffset() + aPartition.getLength(), end);
                return new Region(start, end - start);
            }
            catch (BadLocationException badLocationException) {}
        }
        return aPartition;
    }

    public void createPresentation(TextPresentation aPresentation, ITypedRegion aRegion) {
        this.addRange(aPresentation, aRegion.getOffset(), aRegion.getLength(), this.fDefaultTextAttribute);
    }

    protected void addRange(TextPresentation aPresentation, int anOffset, int aLength, TextAttribute anAttr) {
        if (anAttr != null) {
            aPresentation.addStyleRange(new StyleRange(anOffset, aLength, anAttr.getForeground(), anAttr.getBackground(), anAttr.getStyle()));
        }
    }
}

