/*
 * Decompiled with CFR 0.152.
 */
package org.vaulttec.velocity.ui.editor.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class VelocityTextGuesser {
    public static final int TYPE_INVALID = 0;
    public static final int TYPE_DIRECTIVE = 1;
    public static final int TYPE_VARIABLE = 2;
    private int fType;
    private String fText;
    private int fLine;

    public VelocityTextGuesser() {
        this.fType = 0;
        this.fText = "";
        this.fLine = -1;
    }

    public VelocityTextGuesser(IDocument aDocument, int anOffset, boolean aGuessEnd) {
        try {
            int start = anOffset;
            while (start >= 1 && VelocityTextGuesser.isWordPart(aDocument.getChar(start - 1))) {
                --start;
            }
            int end = anOffset;
            if (aGuessEnd) {
                int len = aDocument.getLength() - 1;
                while (end < len && VelocityTextGuesser.isWordPart(aDocument.getChar(end))) {
                    ++end;
                }
            }
            this.fText = aDocument.get(start, end - start);
            this.fLine = aDocument.getLineOfOffset(start) + 1;
            if (start >= 1) {
                char c1 = aDocument.getChar(start - 1);
                if (c1 == '#') {
                    this.fType = 1;
                } else if (c1 == '$') {
                    this.fType = 2;
                } else if (start >= 2) {
                    char c3;
                    char c2 = aDocument.getChar(start - 2);
                    if (c2 == '$' && (c1 == '{' || c1 == '!')) {
                        this.fType = 2;
                    } else if (start >= 3 && ((c3 = aDocument.getChar(start - 3)) == '$' && c2 == '!' || c1 == '{')) {
                        this.fType = 2;
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {
            this.fType = 0;
            this.fText = "";
            this.fLine = -1;
        }
    }

    public int getType() {
        return this.fType;
    }

    public String getText() {
        return this.fText;
    }

    public int getLine() {
        return this.fLine;
    }

    private static final boolean isWordPart(char aChar) {
        return Character.isLetterOrDigit(aChar) || aChar == '-' || aChar == '_';
    }

    public String toString() {
        return "type=" + this.fType + ", text=" + this.fText + ", line=" + this.fLine;
    }
}

