/*
 * Decompiled with CFR 0.152.
 */
package org.vaulttec.velocity.ui.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.vaulttec.velocity.ui.editor.VelocityEditorEnvironment;
import org.vaulttec.velocity.ui.model.AbstractTreeNode;
import org.vaulttec.velocity.ui.model.IBlock;
import org.vaulttec.velocity.ui.model.ITreeNode;
import org.vaulttec.velocity.ui.model.ITreeVisitor;

public class Directive
extends AbstractTreeNode
implements IBlock {
    public static final int TYPE_SET = 0;
    public static final int TYPE_IF = 1;
    public static final int TYPE_ELSE = 2;
    public static final int TYPE_ELSEIF = 3;
    public static final int TYPE_END = 4;
    public static final int TYPE_FOREACH = 5;
    public static final int TYPE_INCLUDE = 6;
    public static final int TYPE_PARSE = 7;
    public static final int TYPE_MACRO = 8;
    public static final int TYPE_STOP = 9;
    public static final int TYPE_MACRO_CALL = 10;
    public static final int TYPE_USER_DIRECTIVE = 11;
    private int fType;
    private String fName;
    private ArrayList<String> fParameters;
    public static final String[] DIRECTIVES = new String[]{"#set", "#if", "#else", "#elseif", "#end", "#foreach", "#include", "#parse", "#macro", "#stop"};
    private String fId;
    protected Vector<Directive> fDirectives = new Vector();

    public Directive(int aType, String aName, String anId, ITreeNode aParent, int aStartLine, int anEndLine) {
        super(aParent, aStartLine, anEndLine);
        this.fName = aName;
        this.fType = aType;
        this.fId = anId;
    }

    public int getType() {
        return this.fType;
    }

    public static int getType(String aName) {
        int i = 0;
        while (i < DIRECTIVES.length) {
            if (DIRECTIVES[i].equals(aName)) {
                return i;
            }
            ++i;
        }
        if (VelocityEditorEnvironment.getParser().isUserDirective(aName)) {
            return 11;
        }
        return 10;
    }

    public String getId() {
        return this.fId;
    }

    public void addParameter(String aParameter) {
        if (this.fParameters == null) {
            this.fParameters = new ArrayList();
        }
        this.fParameters.add(aParameter);
    }

    public ArrayList<String> getParameters() {
        return this.fParameters;
    }

    @Override
    public void addDirective(Directive aDirective) {
        this.fDirectives.add(aDirective);
    }

    @Override
    public String getName() {
        return this.fType < 10 ? String.valueOf(DIRECTIVES[this.fType]) + (this.fType != 2 ? " (" + this.fName + ")" : "") : "#" + this.fName;
    }

    @Override
    public boolean hasChildren() {
        return !this.fDirectives.isEmpty();
    }

    @Override
    public Object[] getChildren() {
        return this.fDirectives.toArray();
    }

    @Override
    public boolean accept(ITreeVisitor aVisitor) {
        boolean more = true;
        Iterator<Directive> iter = this.fDirectives.iterator();
        while (more && iter.hasNext()) {
            more = ((ITreeNode)iter.next()).accept(aVisitor);
        }
        if (more) {
            more = aVisitor.visit(this);
        }
        return more;
    }

    @Override
    public String getUniqueID() {
        return String.valueOf(this.getName()) + ":" + this.getStartLine();
    }

    public String toString() {
        return String.valueOf(this.getUniqueID()) + ":" + this.getEndLine() + " with directive(s) " + this.fDirectives;
    }
}

