/*
 * Decompiled with CFR 0.152.
 */
package org.vaulttec.velocity.ui.model;

import com.langtags.ep4velo.Activator;
import java.util.ArrayList;
import java.util.List;
import org.vaulttec.velocity.ui.editor.VelocityEditor;
import org.vaulttec.velocity.ui.editor.text.VelocityTextGuesser;
import org.vaulttec.velocity.ui.model.Directive;
import org.vaulttec.velocity.ui.model.ITreeNode;
import org.vaulttec.velocity.ui.model.ITreeVisitor;

public class ModelTools {
    private VelocityEditor fEditor;

    public ModelTools(VelocityEditor anEditor) {
        this.fEditor = anEditor;
    }

    public ITreeNode getNodeByLine(int aLine) {
        ITreeNode node = this.fEditor.getRootNode();
        if (node != null) {
            TreeNodeLineVisitor visitor = new TreeNodeLineVisitor(aLine);
            node.accept(visitor);
            return visitor.getNode();
        }
        return null;
    }

    public ITreeNode getNodeByGuess(VelocityTextGuesser aGuess) {
        ITreeNode node = this.fEditor.getRootNode();
        if (node != null) {
            String id;
            if (aGuess.getType() == 2) {
                id = "$" + aGuess.getText();
            } else if (aGuess.getType() == 1) {
                id = aGuess.getText();
            } else {
                return null;
            }
            TreeNodeIdVisitor visitor = new TreeNodeIdVisitor(id, aGuess.getLine());
            node.accept(visitor);
            return visitor.getNode();
        }
        return null;
    }

    public boolean isLineWithinLoop(int aLine) {
        ITreeNode node = this.fEditor.getRootNode();
        if (node != null && aLine > 0) {
            TreeNodeLineVisitor visitor = new TreeNodeLineVisitor(aLine);
            node.accept(visitor);
            node = visitor.getNode();
            while (node != null) {
                Directive directive;
                if (node instanceof Directive && (directive = (Directive)node).getType() == 5) {
                    return true;
                }
                node = (ITreeNode)node.getParent();
            }
        }
        return false;
    }

    public List<String> getVariables(int aLine) {
        ITreeNode node = this.fEditor.getLastRootNode();
        if (node != null) {
            TreeNodeVariableVisitor visitor = new TreeNodeVariableVisitor(aLine);
            node.accept(visitor);
            List<String> variables = visitor.getVariables();
            if (this.isLineWithinLoop(this.fEditor.getCursorLine())) {
                String countName = "$" + Activator.getDefault().getPreferenceStore().getString("com.langtags.ep4velo.velocity.countName");
                variables.add(countName);
            }
            return variables;
        }
        return new ArrayList<String>();
    }

    public List<String> getMacros() {
        ITreeNode node = this.fEditor.getLastRootNode();
        if (node != null) {
            TreeNodeMacroVisitor visitor = new TreeNodeMacroVisitor();
            node.accept(visitor);
            return visitor.getMacros();
        }
        return new ArrayList<String>();
    }

    private class TreeNodeIdVisitor
    implements ITreeVisitor {
        private String fId;
        private int fLine;
        private ITreeNode fNode;

        public TreeNodeIdVisitor(String anId, int aLine) {
            this.fId = anId;
            this.fLine = aLine;
            this.fNode = null;
        }

        @Override
        public boolean visit(ITreeNode aNode) {
            if (aNode.getStartLine() < this.fLine && aNode instanceof Directive) {
                Directive directive = (Directive)aNode;
                if (directive.getType() == 8) {
                    ArrayList<String> parameters;
                    if (directive.getId().equals(this.fId)) {
                        this.fNode = aNode;
                    } else if (this.fLine >= aNode.getStartLine() && this.fLine <= aNode.getEndLine() && (parameters = ((Directive)aNode).getParameters()) != null && parameters.contains(this.fId)) {
                        this.fNode = aNode;
                    }
                } else {
                    String id = directive.getId();
                    if (id != null && id.equals(this.fId)) {
                        this.fNode = aNode;
                    }
                }
            }
            return true;
        }

        public ITreeNode getNode() {
            return this.fNode;
        }
    }

    private class TreeNodeLineVisitor
    implements ITreeVisitor {
        private int fLine;
        private ITreeNode fNode;

        public TreeNodeLineVisitor(int aLine) {
            this.fLine = aLine;
            this.fNode = null;
        }

        @Override
        public boolean visit(ITreeNode aNode) {
            boolean more;
            if (this.fLine >= aNode.getStartLine() && this.fLine <= aNode.getEndLine()) {
                this.fNode = aNode;
                more = false;
            } else {
                more = true;
            }
            return more;
        }

        public ITreeNode getNode() {
            return this.fNode;
        }
    }

    private class TreeNodeMacroVisitor
    implements ITreeVisitor {
        private List<String> fMacros = new ArrayList<String>();

        @Override
        public boolean visit(ITreeNode aNode) {
            int type;
            if (aNode instanceof Directive && (type = ((Directive)aNode).getType()) == 8) {
                this.fMacros.add(((Directive)aNode).getId());
            }
            return true;
        }

        public List<String> getMacros() {
            return this.fMacros;
        }
    }

    private class TreeNodeVariableVisitor
    implements ITreeVisitor {
        private int fLine;
        private List<String> fVariables;

        public TreeNodeVariableVisitor(int aLine) {
            this.fLine = aLine;
            this.fVariables = new ArrayList<String>();
        }

        @Override
        public boolean visit(ITreeNode aNode) {
            if (aNode instanceof Directive) {
                ArrayList<String> parameters;
                int type = ((Directive)aNode).getType();
                if (type == 5 || type == 0) {
                    String variable = ((Directive)aNode).getId();
                    if (!this.fVariables.contains(variable)) {
                        this.fVariables.add(variable);
                    }
                } else if (type == 8 && this.fLine >= aNode.getStartLine() && this.fLine <= aNode.getEndLine() && (parameters = ((Directive)aNode).getParameters()) != null) {
                    this.fVariables.addAll(parameters);
                }
            }
            return true;
        }

        public List<String> getVariables() {
            return this.fVariables;
        }
    }
}

