/*
 * Decompiled with CFR 0.152.
 */
package org.vaulttec.velocity.ui.preferences;

import com.langtags.ep4velo.Activator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DirectiveDialog
extends InputDialog {
    protected static String PREFIX = "VelocityPreferences.directive.dialog.";
    protected static IInputValidator VALIDATOR = new DirectiveValidator();
    private Button fLineButton;
    private Button fBlockButton;
    private boolean fIsBlock;

    public DirectiveDialog(Shell aShell) {
        super(aShell, Activator.getMessage(String.valueOf(PREFIX) + "title"), Activator.getMessage(String.valueOf(PREFIX) + "message"), null, VALIDATOR);
    }

    protected Control createDialogArea(Composite aParent) {
        Composite composite = (Composite)super.createDialogArea(aParent);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 8;
        layout.numColumns = 2;
        Group group = new Group(composite, 16384);
        group.setFont(aParent.getFont());
        group.setText(Activator.getMessage(String.valueOf(PREFIX) + "typeGroup"));
        group.setLayout((Layout)layout);
        this.fLineButton = DirectiveDialog.createRadioButton((Composite)group, Activator.getMessage(String.valueOf(PREFIX) + "typeLine"));
        this.fLineButton.setSelection(!this.fIsBlock);
        this.fLineButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectiveDialog.this.fIsBlock = false;
            }
        });
        this.fBlockButton = DirectiveDialog.createRadioButton((Composite)group, Activator.getMessage(String.valueOf(PREFIX) + "typeBlock"));
        this.fBlockButton.setSelection(this.fIsBlock);
        this.fBlockButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectiveDialog.this.fIsBlock = true;
            }
        });
        return composite;
    }

    protected static Button createRadioButton(Composite aParent, String aLabel) {
        Button button = new Button(aParent, 16400);
        button.setText(aLabel);
        button.setFont(aParent.getFont());
        return button;
    }

    public String getValue() {
        return String.valueOf(super.getValue()) + " [" + (this.fIsBlock ? "Block" : "Line") + ']';
    }

    private static class DirectiveValidator
    implements IInputValidator {
        private DirectiveValidator() {
        }

        public String isValid(String aText) {
            if (aText.length() == 0) {
                return "";
            }
            int i = aText.length() - 1;
            while (i >= 0) {
                if (!Character.isLetterOrDigit(aText.charAt(i))) {
                    return Activator.getMessage(String.valueOf(PREFIX) + "error");
                }
                --i;
            }
            return null;
        }
    }
}

